/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.save.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.viaversion.viafabricplus.ViaFabricPlusImpl;
import com.viaversion.viafabricplus.save.AbstractSave;
import com.viaversion.viafabricplus.settings.impl.BedrockSettings;
import de.florianmichael.classic4j.model.classicube.account.CCAccount;
import net.raphimc.minecraftauth.MinecraftAuth;
import net.raphimc.minecraftauth.step.AbstractStep;
import net.raphimc.minecraftauth.step.bedrock.session.StepFullBedrockSession;
import net.raphimc.minecraftauth.step.msa.StepMsaToken;
import net.raphimc.minecraftauth.step.xbl.session.StepInitialXblSession;

public final class AccountsSave
extends AbstractSave {
    private StepFullBedrockSession.FullBedrockSession bedrockAccount;
    private CCAccount classicubeAccount;

    public AccountsSave() {
        super("accounts");
    }

    @Override
    public void write(JsonObject object) {
        if (this.bedrockAccount != null) {
            object.add("bedrockV2", (JsonElement)BedrockSettings.BEDROCK_DEVICE_CODE_LOGIN.toJson((AbstractStep.StepResult)this.bedrockAccount));
        }
        if (this.classicubeAccount != null) {
            object.add("classicube", (JsonElement)this.classicubeAccount.asJson());
        }
    }

    @Override
    public void read(JsonObject object) {
        this.handleAccount("bedrock", object, account -> {
            StepFullBedrockSession.FullBedrockSession oldSession = (StepFullBedrockSession.FullBedrockSession)MinecraftAuth.BEDROCK_DEVICE_CODE_LOGIN.fromJson(account);
            StepInitialXblSession.InitialXblSession xblSession = oldSession.getMcChain().getXblXsts().getInitialXblSession();
            StepMsaToken.RefreshToken refreshToken = new StepMsaToken.RefreshToken(xblSession.getMsaToken().getRefreshToken());
            this.bedrockAccount = (StepFullBedrockSession.FullBedrockSession)BedrockSettings.BEDROCK_DEVICE_CODE_LOGIN.getFromInput(MinecraftAuth.createHttpClient(), (AbstractStep.InitialInput)refreshToken);
        });
        this.handleAccount("bedrockV2", object, account -> {
            this.bedrockAccount = (StepFullBedrockSession.FullBedrockSession)BedrockSettings.BEDROCK_DEVICE_CODE_LOGIN.fromJson(account);
        });
        this.handleAccount("classicube", object, account -> {
            this.classicubeAccount = CCAccount.fromJson((JsonObject)account);
        });
    }

    private void handleAccount(String name, JsonObject object, AccountConsumer output) {
        if (object.has(name)) {
            try {
                output.accept(object.get(name).getAsJsonObject());
            }
            catch (Exception e) {
                ViaFabricPlusImpl.INSTANCE.getLogger().error("Failed to read {} account!", (Object)name, (Object)e);
            }
        }
    }

    public StepFullBedrockSession.FullBedrockSession refreshAndGetBedrockAccount() {
        if (this.bedrockAccount == null) {
            return null;
        }
        try {
            this.bedrockAccount = (StepFullBedrockSession.FullBedrockSession)BedrockSettings.BEDROCK_DEVICE_CODE_LOGIN.refresh(MinecraftAuth.createHttpClient(), (AbstractStep.StepResult)this.bedrockAccount);
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to refresh Bedrock chain data. Please re-login to Bedrock!", t);
        }
        return this.bedrockAccount;
    }

    public StepFullBedrockSession.FullBedrockSession getBedrockAccount() {
        return this.bedrockAccount;
    }

    public void setBedrockAccount(StepFullBedrockSession.FullBedrockSession bedrockAccount) {
        this.bedrockAccount = bedrockAccount;
    }

    public CCAccount getClassicubeAccount() {
        return this.classicubeAccount;
    }

    public void setClassicubeAccount(CCAccount classicubeAccount) {
        this.classicubeAccount = classicubeAccount;
    }

    @FunctionalInterface
    static interface AccountConsumer {
        public void accept(JsonObject var1) throws Exception;
    }
}

