/*
 * Decompiled with CFR 0.152.
 */
package codes.atomys.advr.screens;

import codes.atomys.advr.ReloadedCriterionProgress;
import codes.atomys.advr.ReloadedWidgetType;
import codes.atomys.advr.config.Configuration;
import codes.atomys.advr.screens.AdvancementReloadedTab;
import codes.atomys.advr.utils.TextUtils;
import codes.atomys.advr.utils.Utils;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_161;
import net.minecraft.class_167;
import net.minecraft.class_185;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_5225;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8781;
import org.jetbrains.annotations.Nullable;

public class AdvancementReloadedWidget {
    private static final class_2960 TITLE_BOX_TEXTURE = class_2960.method_60656((String)"advancements/title_box");
    private static final int[] SPLIT_OFFSET_CANDIDATES = new int[]{0, 10, -10, 25, -25};
    private final AdvancementReloadedTab tab;
    private final class_8781 advancement;
    private final class_185 display;
    private final class_5481 title;
    private final int width;
    private final List<class_5481> description;
    private final class_310 client;
    @Nullable
    private AdvancementReloadedWidget parent;
    private final List<AdvancementReloadedWidget> children = Lists.newArrayList();
    @Nullable
    private class_167 progress;
    private List<ReloadedCriterionProgress> steps;
    private final int x;
    private final int y;
    private final RenderPipeline renderTypeGui = class_10799.field_56883;

    public AdvancementReloadedWidget(AdvancementReloadedTab tab, class_310 client, class_8781 advancement, class_185 display) {
        this.tab = tab;
        this.advancement = advancement;
        this.display = display;
        this.client = client;
        this.title = class_2477.method_10517().method_30934(client.field_1772.method_1714((class_5348)display.method_811(), 163));
        this.x = class_3532.method_15375((float)(display.method_818() * 28.0f));
        this.y = class_3532.method_15375((float)(display.method_819() * 27.0f));
        int i = this.getProgressWidth();
        int j = 29 + client.field_1772.method_30880(this.title) + i;
        this.description = class_2477.method_10517().method_30933(this.wrapDescription((class_2561)class_2564.method_10889((class_5250)display.method_817().method_27661(), (class_2583)class_2583.field_24360.method_10977(display.method_815().method_830())), j));
        for (class_5481 orderedText : this.description) {
            j = Math.max(j, client.field_1772.method_30880(orderedText));
        }
        if (this.progress != null) {
            this.setSteps(this.progress);
        }
        this.width = j + 3 + 5;
    }

    private int getProgressWidth() {
        int i = this.advancement.method_53647().comp_1916().method_53664();
        if (i <= 1) {
            return 0;
        }
        int j = 8;
        class_5250 mutableText = class_2561.method_43469((String)"advancements.progress", (Object[])new Object[]{i, i});
        return this.client.field_1772.method_27525((class_5348)mutableText) + 8;
    }

    private static float getMaxWidth(class_5225 strSplitter, List<class_5348> lines) {
        Objects.requireNonNull(strSplitter);
        return (float)lines.stream().mapToDouble(arg_0 -> ((class_5225)strSplitter).method_27488(arg_0)).max().orElse(0.0);
    }

    private List<class_5348> wrapDescription(class_2561 text, int width) {
        class_5225 strSplitter = this.client.field_1772.method_27527();
        List list = null;
        float f = Float.MAX_VALUE;
        for (int i : SPLIT_OFFSET_CANDIDATES) {
            List list2 = strSplitter.method_27495((class_5348)text, width - i, class_2583.field_24360);
            float g = Math.abs(AdvancementReloadedWidget.getMaxWidth(strSplitter, list2) - (float)width);
            if (g <= 10.0f) {
                return list2;
            }
            if (!(g < f)) continue;
            f = g;
            list = list2;
        }
        return list;
    }

    @Nullable
    private AdvancementReloadedWidget getParent(class_8781 advancement) {
        while ((advancement = advancement.method_53651()) != null && advancement.method_53647().comp_1913().isEmpty()) {
        }
        if (advancement != null && advancement.method_53647().comp_1913().isPresent()) {
            return this.tab.getWidget(advancement.method_53649());
        }
        Utils.LOGGER.warn("advancement parent cannot be retrieved from the advancement: " + String.valueOf(advancement));
        return null;
    }

    public class_161 getAdvancement() {
        return this.advancement.method_53647();
    }

    public class_167 getProgress() {
        return this.progress;
    }

    public List<ReloadedCriterionProgress> getSteps() {
        if (this.steps == null) {
            return Collections.emptyList();
        }
        return this.steps;
    }

    public boolean isSearchQueryMatched() {
        String search = this.tab.getScreen().getSearchText();
        if (search == null || search.isEmpty() || search.trim().isEmpty()) {
            return true;
        }
        String searchLower = search.toLowerCase();
        if (TextUtils.toString(this.display.method_811()).toLowerCase().contains(searchLower)) {
            return true;
        }
        for (class_5481 line : this.description) {
            if (!TextUtils.toString(line).toLowerCase().contains(searchLower)) continue;
            return true;
        }
        for (ReloadedCriterionProgress step : this.steps) {
            if (!TextUtils.toString(step.getHumanCriterionName()).toLowerCase().contains(searchLower)) continue;
            return true;
        }
        return false;
    }

    public void renderLines(class_332 context, int x, int y, boolean border) {
        if (this.parent != null) {
            int n;
            int i = x + this.parent.x + 13;
            int j = x + this.parent.x + 26 + 4;
            int k = y + this.parent.y + 13;
            int l = x + this.x + 13;
            int m = y + this.y + 13;
            int n2 = n = border ? -16777216 : -1;
            if (border) {
                context.method_51738(j, i, k - 1, n);
                context.method_51738(j + 1, i, k, n);
                context.method_51738(j, i, k + 1, n);
                context.method_51738(l, j - 1, m - 1, n);
                context.method_51738(l, j - 1, m, n);
                context.method_51738(l, j - 1, m + 1, n);
                context.method_51742(j - 1, m, k, n);
                context.method_51742(j + 1, m, k, n);
            } else {
                context.method_51738(j, i, k, n);
                context.method_51738(l, j, m, n);
                context.method_51742(j, m, k, n);
            }
        }
        for (AdvancementReloadedWidget advancementWidget : this.children) {
            advancementWidget.renderLines(context, x, y, border);
        }
    }

    public void renderWidgets(class_332 context, int x, int y) {
        if (!this.display.method_824() || this.progress != null && this.progress.method_740()) {
            float currentProgress = this.progress == null ? 0.0f : this.progress.method_735();
            ReloadedWidgetType widgetType = currentProgress >= 1.0f ? ReloadedWidgetType.OBTAINED : ReloadedWidgetType.UNOBTAINED;
            boolean isDimmed = !this.isSearchQueryMatched();
            class_2960 backgroundResource = widgetType.frameSprite(this.display.method_815(), isDimmed);
            context.method_52706(this.renderTypeGui, backgroundResource, x + this.x + 3, y + this.y, 26, 26);
            context.method_51445(this.display.method_821(), x + this.x + 8, y + this.y + 5);
            if (isDimmed) {
                class_2960 dimmedResource = widgetType.frameSprite(this.display.method_815(), true);
                context.method_71501(this.renderTypeGui, dimmedResource, x + this.x + 3, y + this.y, 26, 26, 0.6f);
            }
        }
        for (AdvancementReloadedWidget advancementWidget : this.children) {
            advancementWidget.renderWidgets(context, x, y);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setProgress(class_167 progress) {
        this.progress = progress;
        this.setSteps(progress);
    }

    public void setSteps(class_167 progress) {
        ArrayList<ReloadedCriterionProgress> steps = new ArrayList<ReloadedCriterionProgress>();
        ArrayList remainingCriteriaIterable = progress.method_731();
        ArrayList completedCriteriaIterable = progress.method_734();
        if (Configuration.criteriasAlphabeticOrder) {
            ArrayList unobtainedList = new ArrayList();
            ArrayList obtainedList = new ArrayList();
            remainingCriteriaIterable.forEach(unobtainedList::add);
            completedCriteriaIterable.forEach(obtainedList::add);
            unobtainedList.sort(String::compareToIgnoreCase);
            obtainedList.sort(String::compareToIgnoreCase);
            remainingCriteriaIterable = unobtainedList;
            completedCriteriaIterable = obtainedList;
        }
        remainingCriteriaIterable.forEach(criterion -> steps.add(new ReloadedCriterionProgress(this.advancement, progress, (String)criterion)));
        completedCriteriaIterable.forEach(criterion -> steps.add(new ReloadedCriterionProgress(this.advancement, progress, (String)criterion)));
        this.steps = steps;
    }

    public void addChild(AdvancementReloadedWidget widget) {
        this.children.add(widget);
    }

    public void drawTooltip(class_332 context, int originX, int originY, float alpha, int x, int y) {
        ReloadedWidgetType advancementObtainedStatus3;
        ReloadedWidgetType advancementObtainedStatus2;
        ReloadedWidgetType advancementObtainedStatus;
        boolean bl = x + originX + this.x + this.width + 26 >= this.tab.getScreen().field_22789;
        class_2561 text = this.progress == null ? null : this.progress.method_728();
        int i = text == null ? 0 : this.client.field_1772.method_27525((class_5348)text);
        Objects.requireNonNull(this.client.field_1772);
        boolean bl2 = 113 - originY - this.y - 26 <= 6 + this.description.size() * 9;
        float f = this.progress == null ? 0.0f : this.progress.method_735();
        int j = class_3532.method_15375((float)(f * (float)this.width));
        if (f >= 1.0f) {
            j = this.width / 2;
            advancementObtainedStatus = ReloadedWidgetType.OBTAINED;
            advancementObtainedStatus2 = ReloadedWidgetType.OBTAINED;
            advancementObtainedStatus3 = ReloadedWidgetType.OBTAINED;
        } else if (j < 2) {
            j = this.width / 2;
            advancementObtainedStatus = ReloadedWidgetType.UNOBTAINED;
            advancementObtainedStatus2 = ReloadedWidgetType.UNOBTAINED;
            advancementObtainedStatus3 = ReloadedWidgetType.UNOBTAINED;
        } else if (j > this.width - 2) {
            j = this.width / 2;
            advancementObtainedStatus = ReloadedWidgetType.OBTAINED;
            advancementObtainedStatus2 = ReloadedWidgetType.OBTAINED;
            advancementObtainedStatus3 = ReloadedWidgetType.UNOBTAINED;
        } else {
            advancementObtainedStatus = ReloadedWidgetType.OBTAINED;
            advancementObtainedStatus2 = ReloadedWidgetType.UNOBTAINED;
            advancementObtainedStatus3 = ReloadedWidgetType.UNOBTAINED;
        }
        int k = this.width - j;
        int l = originY + this.y;
        int m = bl ? originX + this.x - this.width + 26 + 6 : originX + this.x;
        Objects.requireNonNull(this.client.field_1772);
        int n = 32 + this.description.size() * 9;
        if (!this.description.isEmpty()) {
            if (bl2) {
                context.method_52706(this.renderTypeGui, TITLE_BOX_TEXTURE, m, l + 26 - n, this.width, n);
            } else {
                context.method_52706(this.renderTypeGui, TITLE_BOX_TEXTURE, m, l, this.width, n);
            }
        }
        boolean isDimmed = !this.isSearchQueryMatched();
        context.method_70846(this.renderTypeGui, advancementObtainedStatus.boxSprite(isDimmed), 200, 26, 0, 0, m, l, j, 26);
        context.method_70846(this.renderTypeGui, advancementObtainedStatus2.boxSprite(isDimmed), 200, 26, 200 - k, 0, m + j, l, k, 26);
        context.method_52706(this.renderTypeGui, advancementObtainedStatus3.frameSprite(this.display.method_815(), isDimmed), originX + this.x + 3, originY + this.y, 26, 26);
        if (bl) {
            context.method_35720(this.client.field_1772, this.title, m + 5, originY + this.y + 9, -1);
            if (text != null) {
                context.method_27535(this.client.field_1772, text, originX + this.x - i, originY + this.y + 9, -1);
            }
        } else {
            context.method_35720(this.client.field_1772, this.title, originX + this.x + 32, originY + this.y + 9, -1);
            if (text != null) {
                context.method_27535(this.client.field_1772, text, originX + this.x + this.width - i - 5, originY + this.y + 9, -1);
            }
        }
        if (bl2) {
            for (int o = 0; o < this.description.size(); ++o) {
                Objects.requireNonNull(this.client.field_1772);
                context.method_51430(this.client.field_1772, this.description.get(o), m + 5, l + 26 - n + 7 + o * 9, -5592406, false);
            }
        } else {
            for (int o = 0; o < this.description.size(); ++o) {
                Objects.requireNonNull(this.client.field_1772);
                context.method_51430(this.client.field_1772, this.description.get(o), m + 5, originY + this.y + 9 + 17 + o * 9, -5592406, false);
            }
        }
        context.method_51445(this.display.method_821(), originX + this.x + 8, originY + this.y + 5);
    }

    public boolean shouldRender(int originX, int originY, int mouseX, int mouseY) {
        if (this.display.method_824() && (this.progress == null || !this.progress.method_740())) {
            return false;
        }
        return this.isMouseOn(originX, originY, mouseX, mouseY);
    }

    public boolean isMouseOn(int originX, int originY, double mouseX, double mouseY) {
        return (double)(originX + this.x) < mouseX && mouseX < (double)(originX + this.x + 26) && (double)(originY + this.y) < mouseY && mouseY < (double)(originY + this.y + 26);
    }

    public void addToTree() {
        if (this.parent == null && this.advancement.method_53651() != null) {
            this.parent = this.getParent(this.advancement);
            if (this.parent != null) {
                this.parent.addChild(this);
            }
        }
    }

    public int getY() {
        return this.y;
    }

    public int getX() {
        return this.x;
    }
}

