/*
 * Decompiled with CFR 0.152.
 */
package codes.atomys.advr.screens;

import codes.atomys.advr.ClickableRegion;
import codes.atomys.advr.ReloadedCriterionProgress;
import codes.atomys.advr.ReloadedDisplayInfo;
import codes.atomys.advr.TabPlacement;
import codes.atomys.advr.config.Configuration;
import codes.atomys.advr.config.gui.ConfigurationScreen;
import codes.atomys.advr.screens.AdvancementReloadedTab;
import codes.atomys.advr.screens.AdvancementReloadedWidget;
import codes.atomys.advr.utils.Memory;
import codes.atomys.advr.utils.Utils;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1060;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_12079;
import net.minecraft.class_124;
import net.minecraft.class_167;
import net.minecraft.class_185;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2859;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_632;
import net.minecraft.class_634;
import net.minecraft.class_8662;
import net.minecraft.class_8779;
import net.minecraft.class_8781;
import net.minecraft.class_9848;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class AdvancementReloadedScreen
extends class_437
implements class_632.class_633 {
    private static final class_2960 criteriasSeparator = class_2960.method_60654((String)"advancements_reloaded:textures/gui/inworld_right_separator.png");
    private static final class_2960 GEAR_GUI_SPRITE_TEXURE = class_2960.method_60654((String)"advancements_reloaded:gear");
    private static final class_2960 SCROLLER_TEXTURE = class_2960.method_60656((String)"widget/scroller");
    private static final class_2960 SCROLLER_BACKGROUND_TEXTURE = class_2960.method_60656((String)"widget/scroller_background");
    private static final class_2561 SAD_LABEL_TEXT = class_2561.method_43471((String)"advancements.sad_label");
    private static final class_2561 EMPTY_TEXT = class_2561.method_43471((String)"advancements.empty");
    private static final class_2561 SEARCH_HINT_TEXT = class_2561.method_43471((String)"text.advancements_reloaded.search_hint").method_27692(class_124.field_1063);
    @Nullable
    private final class_437 parent;
    private final class_632 advancementHandler;
    private Map<class_8779, AdvancementReloadedTab> tabs = Maps.newLinkedHashMap();
    @Nullable
    private Optional<AdvancementReloadedTab> selectedTab;
    private AdvancementReloadedWidget selectedWidget;
    private List<ClickableRegion> clickableRegions;
    private int scrollOffset = 0;
    private int contentHeight = 0;
    private final RenderPipeline renderTypeGui = class_10799.field_56883;
    private class_342 searchBox;
    private String searchText = "";
    private boolean isSearching = false;

    public AdvancementReloadedScreen(class_632 advancementHandler) {
        this(advancementHandler, null);
    }

    public AdvancementReloadedScreen(class_632 advancementHandler, @Nullable class_437 parent) {
        super((class_2561)class_2561.method_43473());
        this.advancementHandler = advancementHandler;
        this.parent = parent;
    }

    protected void method_25426() {
        this.tabs.clear();
        this.selectedTab = null;
        this.selectedWidget = Memory.getWidget();
        this.advancementHandler.method_2862((class_632.class_633)this);
        if (this.selectedTab.isEmpty() && !this.tabs.isEmpty()) {
            AdvancementReloadedTab advancementTab = this.tabs.values().iterator().next();
            this.advancementHandler.method_2864(advancementTab.getRoot().method_53649(), true);
        } else {
            this.selectedTab.ifPresent(tab -> this.advancementHandler.method_2864(tab.getRoot().method_53649(), true));
        }
        this.initClickableRegions();
        this.initComponents();
    }

    private void initComponents() {
        this.initSettingsButton();
        this.initSearchBox();
    }

    private void initSearchBox() {
        this.searchBox = new class_342(this.field_22793, (this.field_22789 - 196) / 2, this.field_22790 - 16 - 5, 196, 16, SEARCH_HINT_TEXT);
        this.searchBox.method_47404(SEARCH_HINT_TEXT);
        this.searchBox.method_1856(true);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(class_9848.method_61334((int)class_124.field_1068.method_532()));
        this.searchBox.method_1858(true);
        this.searchBox.method_1880(32);
        this.searchBox.method_1852(this.searchText);
        this.searchBox.method_1863(this::onSearchTextChanged);
        this.method_37063((class_364)this.searchBox);
    }

    private void initSettingsButton() {
        class_8662 settingsIconButton = (class_8662)this.method_37063((class_364)class_8662.method_52723((class_2561)class_2561.method_43471((String)"options.settings"), button -> this.field_22787.method_1507(ConfigurationScreen.screen(this)), (boolean)true).method_52725(20).method_52727(GEAR_GUI_SPRITE_TEXURE, 14, 14).method_52724());
        settingsIconButton.method_48229(this.field_22789 - 25, 5);
    }

    private void initClickableRegions() {
        this.clickableRegions = new ArrayList<ClickableRegion>();
        this.clickableRegions.add(ClickableRegion.create("advancement_tree", 0, Configuration.headerHeight + 1, this.field_22789 - (this.hasVisibleSidebar() ? Configuration.criteriasWidth : 0), this.field_22790 - Configuration.headerHeight - Configuration.footerHeight));
        if (this.hasVisibleSidebar()) {
            this.clickableRegions.add(ClickableRegion.create("advancement_criterias", this.field_22789 - Configuration.criteriasWidth, Configuration.headerHeight + 1, Configuration.criteriasWidth - 6, this.field_22790 - Configuration.headerHeight - Configuration.footerHeight));
            this.clickableRegions.add(ClickableRegion.create("advancement_criterias_scrollbar", this.field_22789 - 6, Configuration.headerHeight + 1, 6, this.field_22790 - Configuration.footerHeight));
        }
    }

    public void method_25419() {
        this.field_22787.method_1507(this.parent);
    }

    public void method_25432() {
        this.advancementHandler.method_2862(null);
        class_634 clientPlayNetworkHandler = this.field_22787.method_1562();
        if (clientPlayNetworkHandler != null) {
            clientPlayNetworkHandler.method_52787((class_2596)class_2859.method_12414());
        }
    }

    public boolean method_25402(class_11909 event, boolean isDoubleClick) {
        if (event.method_74245() == 0) {
            ClickableRegion.foundRegions(this.clickableRegions, event.comp_4798(), event.comp_4799()).forEach(region -> region.setClicked(true));
            boolean i = false;
            int j = Configuration.headerHeight;
            for (AdvancementReloadedTab advancementTab : this.tabs.values()) {
                AdvancementReloadedWidget clickedWidget;
                if (advancementTab == this.selectedTab.orElse(null) && (clickedWidget = advancementTab.clickOnWidget(0, j, event.comp_4798(), event.comp_4799())) != null) {
                    this.setSelectedWidget(clickedWidget);
                }
                if (!advancementTab.isClickOnTab(0, j, event.comp_4798(), event.comp_4799())) continue;
                this.advancementHandler.method_2864(advancementTab.getRoot().method_53649(), true);
                break;
            }
            if (this.needScrollbarOnCriterias()) {
                ClickableRegion.findRegion(this.clickableRegions, region -> region.getName().equals("advancement_criterias_scrollbar") && region.isClicked()).ifPresent(region -> this.moveScrollbarTo(event.comp_4799()));
            }
        }
        return super.method_25402(event, false);
    }

    private void moveScrollbarTo(double mouseY) {
        int viewableHeight = this.field_22790 - Configuration.headerHeight - Configuration.footerHeight;
        int scrollbarStart = Configuration.headerHeight + 1;
        int scrollbarEnd = this.field_22790 - Configuration.footerHeight - 1;
        int scrollRange = this.contentHeight - viewableHeight;
        double relativeMouseY = mouseY - (double)scrollbarStart;
        int newScrollOffset = (int)(relativeMouseY / (double)(scrollbarEnd - scrollbarStart) * (double)scrollRange);
        newScrollOffset = Math.max(0, Math.min(newScrollOffset, scrollRange));
        this.setScrollOffset(newScrollOffset);
    }

    public boolean method_25406(class_11909 event) {
        if (event.method_74245() == 0) {
            ClickableRegion.foundClickedRegions(this.clickableRegions).forEach(region -> region.setClicked(false));
        }
        return super.method_25406(event);
    }

    public boolean method_25403(class_11909 event, double deltaX, double deltaY) {
        ClickableRegion.foundClickedRegions(this.clickableRegions).forEach(region -> {
            switch (region.getName()) {
                case "advancement_tree": {
                    if (!this.selectedTab.isPresent()) break;
                    this.selectedTab.get().move(deltaX, deltaY);
                    break;
                }
                case "advancement_criterias": {
                    this.setScrollOffset(this.scrollOffset - (int)deltaY);
                    break;
                }
                case "advancement_criterias_scrollbar": {
                    this.moveScrollbarTo(event.comp_4799());
                    break;
                }
            }
        });
        return true;
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        ClickableRegion.foundRegions(this.clickableRegions, mouseX, mouseY).forEach(region -> {
            switch (region.getName()) {
                case "advancement_tree": {
                    if (!this.selectedTab.isPresent()) break;
                    this.selectedTab.get().move(horizontalAmount * 16.0, verticalAmount * 16.0);
                    break;
                }
                case "advancement_criterias": 
                case "advancement_criterias_scrollbar": {
                    this.setScrollOffset(this.scrollOffset - (int)verticalAmount * 16);
                }
            }
        });
        return true;
    }

    public boolean method_25404(class_11908 event) {
        if (this.searchBox.method_25370() && this.field_22787.field_1690.field_1844.method_1417(event)) {
            return true;
        }
        if (this.field_22787.field_1690.field_1844.method_1417(event)) {
            this.field_22787.method_1507(this.parent);
            this.field_22787.field_1729.method_1612();
            return true;
        }
        if (256 == event.comp_4795()) {
            if (this.searchBox.method_25370()) {
                this.searchBox.method_25365(false);
                return true;
            }
            if (this.isSearching) {
                this.searchText = "";
                this.searchBox.method_1852("");
                this.isSearching = false;
                return true;
            }
            if (this.hasVisibleSidebar()) {
                this.setSelectedWidget(null);
                this.method_25426();
                return true;
            }
        }
        return super.method_25404(event);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int headerOffset = Configuration.headerHeight + 1;
        context.method_71048();
        this.renderAdvancementTree(context, mouseX, mouseY, 0, headerOffset);
        context.method_71048();
        this.renderAdvancementCriterias(context, 0, headerOffset);
        context.method_71048();
        this.renderWidgetTooltip(context, mouseX, mouseY, 0, headerOffset);
        context.method_71048();
        this.renderWindow(context, 0, headerOffset);
        context.method_71048();
        this.renderRenderable(context, mouseX, mouseY, delta);
    }

    public void renderRenderable(class_332 context, int mouseX, int mouseY, float delta) {
        for (class_4068 renderable : this.field_33816) {
            renderable.method_25394(context, mouseX, mouseY, delta);
        }
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        switch (Configuration.backgroundStyle) {
            case TRANSPARENT: {
                super.method_25420(context, mouseX, mouseY, delta);
                break;
            }
            case BLACK: {
                context.method_25294(0, 0, this.field_22789, this.field_22790, -16777216);
                break;
            }
            case ACHIEVEMENT: {
                this.selectedTab.ifPresent(tab -> {
                    class_2960 textureResourceLocation = tab.getDisplay().method_812().orElse(Utils.INTENTIONAL_MISSING_TEXTURE).comp_3627();
                    context.method_25290(this.renderTypeGui, textureResourceLocation, 0, 0, 0.0f, 0.0f, this.field_22789, this.field_22790, 16, 16);
                });
                context.method_25294(0, 0, this.field_22789, this.field_22790, class_3532.method_15357((double)178.5) << 24);
            }
        }
    }

    private void renderAdvancementTree(class_332 context, int mouseX, int mouseY, int x, int y) {
        if (this.selectedTab.isEmpty()) {
            int n = this.field_22789 / 2;
            int n2 = this.field_22790 / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_27534(this.field_22793, EMPTY_TEXT, n, n2 - 9 * 2, -1);
            int n3 = this.field_22789 / 2;
            int n4 = this.field_22790 / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_27534(this.field_22793, SAD_LABEL_TEXT, n3, n4 + 9 * 2, -1);
        } else {
            this.selectedTab.get().render(context, x, y);
        }
    }

    public void renderAdvancementCriterias(class_332 context, int x, int y) {
        if (!this.hasVisibleSidebar() || Configuration.criteriasWidth == 0) {
            return;
        }
        int paddingTop = Configuration.headerHeight + 6;
        int sidebarXOffset = this.field_22789 - Configuration.criteriasWidth + 8;
        int maxTextWidth = Configuration.criteriasWidth - (this.needScrollbarOnCriterias() ? 6 : 0) - 12;
        class_2561 title = (class_2561)this.getSelectedWidget().getAdvancement().comp_1918().get();
        class_2561 description = ((class_185)this.getSelectedWidget().getAdvancement().comp_1913().get()).method_817();
        context.method_25294(this.field_22789 - Configuration.criteriasWidth, Configuration.headerHeight, this.field_22789, this.field_22790 - Configuration.footerHeight, class_3532.method_15375((float)127.5f) << 24);
        context.method_25290(this.renderTypeGui, criteriasSeparator, this.field_22789 - Configuration.criteriasWidth, Configuration.headerHeight + 1, 0.0f, 0.0f, 2, this.field_22790 - Configuration.headerHeight - Configuration.footerHeight - 2, 2, 32);
        Matrix3x2fStack postStack = context.method_51448();
        postStack.pushMatrix();
        postStack.translate(0.0f, (float)(-this.scrollOffset));
        this.contentHeight = 6;
        context.method_65179(this.field_22793, (class_5348)title, sidebarXOffset, paddingTop, maxTextWidth, -1);
        Objects.requireNonNull(this.field_22793);
        paddingTop += 9 * this.field_22793.method_1728((class_5348)title, maxTextWidth).size() + 4;
        Objects.requireNonNull(this.field_22793);
        this.contentHeight += 9 * this.field_22793.method_1728((class_5348)title, maxTextWidth).size() + 4;
        if (Configuration.displayDescription && description != null) {
            context.method_65179(this.field_22793, (class_5348)description, sidebarXOffset, paddingTop, maxTextWidth, class_9848.method_61334((int)((class_185)this.getSelectedWidget().getAdvancement().comp_1913().get()).method_815().method_830().method_532()));
            Objects.requireNonNull(this.field_22793);
            paddingTop += 9 * this.field_22793.method_1728((class_5348)description, maxTextWidth).size() + 4;
            Objects.requireNonNull(this.field_22793);
            this.contentHeight += 9 * this.field_22793.method_1728((class_5348)description, maxTextWidth).size() + 4;
        }
        context.method_51738(sidebarXOffset, this.field_22789 - 12, paddingTop, -6250336);
        paddingTop += 5;
        this.contentHeight += 5;
        for (ReloadedCriterionProgress step : this.getSelectedWidget().getSteps()) {
            class_2561 stepTitle = step.getHumanCriterionName();
            int lineNeeded = this.field_22793.method_1728((class_5348)stepTitle, maxTextWidth).size();
            context.method_65179(this.field_22793, (class_5348)stepTitle, sidebarXOffset, paddingTop, maxTextWidth, step.getColor());
            Objects.requireNonNull(this.field_22793);
            paddingTop += 9 * lineNeeded + 4;
            Objects.requireNonNull(this.field_22793);
            this.contentHeight += 9 * lineNeeded + 4;
        }
        postStack.popMatrix();
        this.drawAdvancementCriteriaScrollbar(context, x, y);
    }

    private void drawAdvancementCriteriaScrollbar(class_332 context, int x, int y) {
        if (!this.needScrollbarOnCriterias()) {
            return;
        }
        int drawingHeight = this.field_22790 - Configuration.headerHeight - Configuration.footerHeight;
        context.method_52706(this.renderTypeGui, SCROLLER_BACKGROUND_TEXTURE, this.field_22789 - 6, Configuration.headerHeight, 6, drawingHeight);
        int scrollBarHeight = (int)((double)(drawingHeight * drawingHeight) / (double)this.contentHeight);
        int scrollBarY = Configuration.headerHeight + (int)((double)(drawingHeight - scrollBarHeight) * ((double)this.scrollOffset / (double)(this.contentHeight - drawingHeight)));
        context.method_52706(this.renderTypeGui, SCROLLER_TEXTURE, this.field_22789 - 6, scrollBarY, 6, scrollBarHeight);
    }

    private boolean needScrollbarOnCriterias() {
        return this.contentHeight > this.field_22790 - Configuration.headerHeight - Configuration.footerHeight;
    }

    public boolean hasVisibleSidebar() {
        return this.getSelectedWidget() != null && Configuration.displaySidebar;
    }

    public void renderWindow(class_332 context, int x, int y) {
        if (this.selectedTab.isPresent()) {
            ReloadedDisplayInfo display = this.selectedTab.get().getDisplay();
            class_2960 textureResourceLocation = display.method_812().map(class_12079.class_10726::comp_3627).orElse(class_1060.field_5285);
            int headerDrawHeight = Configuration.headerHeight / 16 + 1;
            for (int m = 0; m <= this.field_22789 / 16; ++m) {
                for (int n = 0; n < headerDrawHeight; ++n) {
                    int textureHeight = 16;
                    if (n == headerDrawHeight - 1) {
                        textureHeight = Configuration.headerHeight % 16;
                    }
                    context.method_25290(this.renderTypeGui, textureResourceLocation, 16 * m, 16 * n, 0.0f, 0.0f, 16, textureHeight, 16, 16);
                }
            }
            context.method_25294(0, 0, this.field_22789, Configuration.headerHeight, class_3532.method_15375((float)76.5f) << 24);
            int footerDrawHeight = Configuration.footerHeight / 16 + 1;
            for (int m = 0; m <= this.field_22789 / 16; ++m) {
                for (int n = 0; n < footerDrawHeight; ++n) {
                    int textureHeight = 16;
                    if (n == headerDrawHeight - 1) {
                        textureHeight = Configuration.headerHeight % 16;
                    }
                    context.method_25290(this.renderTypeGui, textureResourceLocation, 16 * m, this.field_22790 - Configuration.footerHeight + 16 * n, 0.0f, 0.0f, 16, textureHeight, 16, 16);
                }
            }
            context.method_25294(0, this.field_22790 - Configuration.footerHeight, this.field_22789, this.field_22790, class_3532.method_15375((float)76.5f) << 24);
            this.drawSeparators(context, 0.7f);
            class_2561 class_25612 = display.method_811();
            int n = this.field_22789 / 2;
            int n2 = (Configuration.headerHeight - 20) / 2;
            Objects.requireNonNull(this.field_22793);
            context.method_27534(this.field_22793, class_25612, n, n2 - 9 / 2, 0xFFFFFF);
        }
        if (this.tabs.size() > 0) {
            for (AdvancementReloadedTab advancementTab : this.tabs.values()) {
                y = advancementTab.getTabPlacement() == TabPlacement.ABOVE ? Configuration.headerHeight + 1 : this.field_22790 - Configuration.footerHeight - 1;
                advancementTab.setPos(x + 4, y);
                advancementTab.drawBackground(context, advancementTab == this.selectedTab.orElse(null));
                advancementTab.drawIcon(context);
                if (advancementTab.isAnyWidgetMatchSearch()) continue;
                advancementTab.drawBackground(context, advancementTab == this.selectedTab.orElse(null), 0.6f);
            }
        }
    }

    private void drawSeparators(class_332 context, float alpha) {
        context.method_25290(this.renderTypeGui, class_437.field_49897, 0, Configuration.headerHeight - 1, 0.0f, 0.0f, this.field_22789, 2, 32, 2);
        context.method_25290(this.renderTypeGui, class_437.field_49898, 0, this.field_22790 - Configuration.footerHeight - 1, 0.0f, 0.0f, this.field_22789, 2, 32, 2);
    }

    private void renderWidgetTooltip(class_332 context, int mouseX, int mouseY, int x, int y) {
        if (this.selectedTab.isPresent()) {
            context.method_51448().pushMatrix();
            context.method_51448().translate((float)x, (float)y);
            this.selectedTab.get().drawWidgetTooltip(context, mouseX - x, mouseY - y, x, y);
            context.method_51448().popMatrix();
        }
        if (this.tabs.size() > 1) {
            for (AdvancementReloadedTab advancementTab : this.tabs.values()) {
                if (!advancementTab.isClickOnTab(x, y, mouseX, mouseY)) continue;
                context.method_51438(this.field_22793, advancementTab.getTitle(), mouseX, mouseY);
            }
        }
    }

    private void sortTabs() {
        ArrayList<AdvancementReloadedTab> sortedTabs = new ArrayList<AdvancementReloadedTab>(this.tabs.values());
        switch (Configuration.tabsOrder) {
            case NONE: {
                break;
            }
            case ALPHABETIC: {
                sortedTabs.sort(Comparator.comparing(AdvancementReloadedTab::getDisplayName));
                break;
            }
            case CONFIGURED_ORDER: {
                sortedTabs.sort(this::compareTabsByConfiguredOrder);
            }
        }
        this.applyTabOrder(sortedTabs);
    }

    private int compareTabsByConfiguredOrder(AdvancementReloadedTab tab1, AdvancementReloadedTab tab2) {
        String tab1Id = tab1.getRoot().method_53649().comp_1919().toString();
        String tab2Id = tab2.getRoot().method_53649().comp_1919().toString();
        int tab1Position = Configuration.customTabsOrder.indexOf(tab1Id);
        int tab2Position = Configuration.customTabsOrder.indexOf(tab2Id);
        if (tab1Position != -1 && tab2Position != -1) {
            return Integer.compare(tab1Position, tab2Position);
        }
        if (tab1Position != -1) {
            return -1;
        }
        if (tab2Position != -1) {
            return 1;
        }
        return tab1.getDisplayName().compareTo(tab2.getDisplayName());
    }

    private void applyTabOrder(List<AdvancementReloadedTab> sortedTabs) {
        this.tabs.clear();
        for (int index = 0; index < sortedTabs.size(); ++index) {
            AdvancementReloadedTab tab = sortedTabs.get(index);
            tab.setIndex(index);
            tab.setTabPlacement(Configuration.aboveWidgetLimit > index ? TabPlacement.ABOVE : TabPlacement.BELOW);
            this.tabs.put(tab.getRoot().method_53649(), tab);
        }
    }

    public void onRootAdded(class_8781 root) {
        AdvancementReloadedTab advancementTab = AdvancementReloadedTab.create(this.field_22787, this, this.tabs.size(), root);
        if (advancementTab != null) {
            this.tabs.put(root.method_53649(), advancementTab);
            this.sortTabs();
        }
    }

    public void onRootRemoved(class_8781 root) {
    }

    public void onDependentAdded(class_8781 dependent) {
        AdvancementReloadedTab advancementTab = this.getTab(dependent);
        if (advancementTab != null) {
            advancementTab.addAdvancement(dependent);
        }
    }

    public void onDependentRemoved(class_8781 dependent) {
    }

    public void method_2865(class_8781 advancement, class_167 progress) {
        AdvancementReloadedWidget advancementWidget = this.getAdvancementWidget(advancement);
        if (advancementWidget != null) {
            advancementWidget.setProgress(progress);
        }
    }

    public void method_2866(@Nullable class_8779 advancement) {
        this.setSelectedTab(this.tabs.get(advancement));
    }

    public void setSelectedTab(AdvancementReloadedTab tab) {
        this.setSelectedTab(Optional.ofNullable(tab));
    }

    public void setSelectedTab(Optional<AdvancementReloadedTab> tab) {
        this.selectedTab = tab;
        this.initClickableRegions();
    }

    public void setSelectedWidget(AdvancementReloadedWidget widget) {
        this.selectedWidget = widget;
        this.scrollOffset = 0;
        Memory.setWidget(widget);
        this.initClickableRegions();
    }

    private void setScrollOffset(int value) {
        if (!this.needScrollbarOnCriterias()) {
            return;
        }
        int max = this.contentHeight - (this.field_22790 - Configuration.headerHeight - Configuration.footerHeight);
        this.scrollOffset = class_3532.method_15340((int)value, (int)0, (int)max);
    }

    @Nullable
    public AdvancementReloadedWidget getSelectedWidget() {
        return this.selectedWidget;
    }

    public void onClear() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    @Nullable
    public AdvancementReloadedWidget getAdvancementWidget(class_8781 advancement) {
        AdvancementReloadedTab advancementTab = this.getTab(advancement);
        return advancementTab == null ? null : advancementTab.getWidget(advancement.method_53649());
    }

    @Nullable
    private AdvancementReloadedTab getTab(class_8781 advancement) {
        class_8781 placedAdvancement = advancement.method_53652();
        return this.tabs.get(placedAdvancement.method_53649());
    }

    public void method_723(class_8781 advancement) {
        AdvancementReloadedTab advancementTab = AdvancementReloadedTab.create(this.field_22787, this, this.tabs.size(), advancement);
        if (advancementTab != null) {
            this.tabs.put(advancement.method_53649(), advancementTab);
            this.sortTabs();
        }
    }

    public void method_720(class_8781 advancement) {
    }

    public void method_721(class_8781 advancement) {
        AdvancementReloadedTab advancementTab = this.getTab(advancement);
        if (advancementTab != null) {
            advancementTab.addAdvancement(advancement);
        }
    }

    public void method_719(class_8781 advancement) {
    }

    public void method_722() {
        this.tabs.clear();
        this.selectedTab = null;
    }

    private void onSearchTextChanged(String text) {
        this.searchText = text;
        this.isSearching = !text.isEmpty();
        for (AdvancementReloadedTab tab : this.tabs.values()) {
            tab.updateDoesWidgetMatchSearch();
        }
        this.initClickableRegions();
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    public String getSearchText() {
        return this.searchText;
    }
}

