/*
 * Decompiled with CFR 0.152.
 */
package codes.atomys.advr.config;

import codes.atomys.advr.config.Configuration;
import codes.atomys.advr.libs.nightconfig.core.Config;
import codes.atomys.advr.libs.nightconfig.core.file.FileConfig;
import codes.atomys.advr.utils.Utils;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;

public final class ModConfigurationFile {
    private static FileType storedFileType;
    public static final Runnable saveRunnable;

    private ModConfigurationFile() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static void load(FileType filetype) {
        storedFileType = filetype;
        File file = new File(storedFileType == FileType.JSON ? "config/advancements_reloaded.json" : "config/advancements_reloaded.toml");
        if (!file.exists()) {
            Utils.LOGGER.info("Configuration file not found, creating new one.");
            saveRunnable.run();
            return;
        }
        Object config = FileConfig.builder(file).concurrent().autosave().build();
        config.load();
        Config appearance = config.getOrElse("appearance", () -> null);
        Config advancedCustomization = config.getOrElse("advanced_customization", () -> null);
        if (appearance == null) {
            config.close();
            return;
        }
        Configuration.displaySidebar = appearance.getOrElse("display_sideabar", Boolean.valueOf(true));
        Configuration.displayDescription = appearance.getOrElse("display_description", Boolean.valueOf(true));
        Configuration.criteriasAlphabeticOrder = appearance.getOrElse("criterias_alphabetic_order", Boolean.valueOf(true));
        Configuration.advancementsOrder = Configuration.AdvancementOrder.valueOf(appearance.getOrElse("advancements_order", "ALPHABETIC").toUpperCase());
        Configuration.tabsOrder = Configuration.TabOrder.valueOf(appearance.getOrElse("tabs_order", "ALPHABETIC").toUpperCase());
        Configuration.backgroundStyle = Configuration.BackgroundStyle.valueOf(appearance.getOrElse("background_style", "TRANSPARENT").toUpperCase());
        Configuration.criteriasTranslationMode = Configuration.TranslationMode.valueOf(appearance.getOrElse("criterias_translation_mode", "ONLY_COMPATIBLE").toUpperCase());
        Configuration.headerHeight = advancedCustomization.getOrElse("header_height", Integer.valueOf(48));
        Configuration.footerHeight = advancedCustomization.getOrElse("footer_height", Integer.valueOf(32));
        Configuration.criteriasWidth = advancedCustomization.getOrElse("criterias_width", Integer.valueOf(142));
        Configuration.aboveWidgetLimit = advancedCustomization.getOrElse("above_widget_limit", Integer.valueOf(14));
        Configuration.belowWidgetLimit = advancedCustomization.getOrElse("below_widget_limit", Integer.valueOf(14));
        Configuration.customTabsOrder = advancedCustomization.getOrElse("custom_tabs_order", () -> new ArrayList());
        Configuration.customAdvancementsOrder = advancedCustomization.getOrElse("custom_advancements_order", () -> new ArrayList());
        config.close();
    }

    static {
        saveRunnable = () -> {
            Path path = Paths.get(storedFileType == FileType.JSON ? "config/advancements_reloaded.json" : "config/advancements_reloaded.toml", new String[0]);
            File file = path.toFile();
            if (!file.exists()) {
                file.getParentFile().mkdirs();
            }
            Object config = FileConfig.builder(path).concurrent().autosave().build();
            Config appearance = Config.inMemory();
            appearance.set("display_sideabar", (Object)Configuration.displaySidebar);
            appearance.set("display_description", (Object)Configuration.displayDescription);
            appearance.set("criterias_alphabetic_order", (Object)Configuration.criteriasAlphabeticOrder);
            appearance.set("advancements_order", (Object)Configuration.advancementsOrder.name());
            appearance.set("tabs_order", (Object)Configuration.tabsOrder.name());
            appearance.set("background_style", (Object)Configuration.backgroundStyle.name());
            appearance.set("criterias_translation_mode", (Object)Configuration.criteriasTranslationMode.name());
            Config advancedCustomization = Config.inMemory();
            advancedCustomization.set("header_height", (Object)Configuration.headerHeight);
            advancedCustomization.set("footer_height", (Object)Configuration.footerHeight);
            advancedCustomization.set("criterias_width", (Object)Configuration.criteriasWidth);
            advancedCustomization.set("above_widget_limit", (Object)Configuration.aboveWidgetLimit);
            advancedCustomization.set("below_widget_limit", (Object)Configuration.belowWidgetLimit);
            advancedCustomization.set("custom_tabs_order", Configuration.customTabsOrder);
            advancedCustomization.set("custom_advancements_order", Configuration.customAdvancementsOrder);
            config.set("appearance", (Object)appearance);
            config.set("advanced_customization", (Object)advancedCustomization);
            config.close();
        };
    }

    public static enum FileType {
        JSON,
        TOML;

    }
}

