/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.cullleaves;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import eu.midnightdust.cullleaves.config.CullLeavesConfig;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2397;
import net.minecraft.class_2680;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import net.minecraft.class_7116;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CullLeavesClient {
    public static final String MOD_ID = "cullleaves";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cullleaves");
    public static boolean forceLeafCulling = false;
    public static boolean forceHideInnerLeaves = false;

    public static boolean shouldHideBlock(class_1922 world, class_2338 pos) {
        if (forceHideInnerLeaves) {
            boolean shouldForceCull = true;
            for (class_2350 dir : class_2350.values()) {
                class_2680 otherState = world.method_8320(pos.method_10093(dir));
                if (otherState.method_26204() instanceof class_2397 || otherState.method_26206(world, pos, dir.method_10153())) continue;
                shouldForceCull = false;
                break;
            }
            return shouldForceCull;
        }
        return false;
    }

    public static boolean isLeafSideInvisible(class_2680 neighborState) {
        if (CullLeavesConfig.enabled || forceLeafCulling) {
            return neighborState.method_26204() instanceof class_2397;
        }
        return false;
    }

    public static boolean isRootSideInvisible(class_2680 neighborState) {
        if (CullLeavesConfig.cullRoots) {
            return neighborState.method_26204() instanceof class_7116;
        }
        return false;
    }

    public static class ReloadListener
    implements class_4013 {
        public static final ReloadListener INSTANCE = new ReloadListener();

        private ReloadListener() {
        }

        public void method_14491(class_3300 manager) {
            forceLeafCulling = false;
            forceHideInnerLeaves = false;
            manager.method_14488("options", path -> path.toString().startsWith(CullLeavesClient.MOD_ID) && path.toString().endsWith("options.json")).forEach((id, resource) -> {
                try {
                    JsonObject json = JsonParser.parseReader((Reader)resource.method_43039()).getAsJsonObject();
                    if (json.has("forceLeafCulling")) {
                        forceLeafCulling = json.get("forceLeafCulling").getAsBoolean();
                        LOGGER.info("Forcing leaf culling as requested by resourcepack");
                    }
                    if (json.has("forceHideInnerLeaves")) {
                        forceHideInnerLeaves = json.get("forceHideInnerLeaves").getAsBoolean();
                        LOGGER.info("Not rendering inner leaves as requested by resourcepack");
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }
}

