/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.controlify.screenop.keyboard;

import dev.isxander.controlify.Controlify;
import dev.isxander.controlify.api.bind.InputBinding;
import dev.isxander.controlify.bindings.ControlifyBindings;
import dev.isxander.controlify.controller.ControllerEntity;
import dev.isxander.controlify.font.BindingFontHelper;
import dev.isxander.controlify.screenop.ComponentProcessor;
import dev.isxander.controlify.screenop.ScreenControllerEventListener;
import dev.isxander.controlify.screenop.ScreenProcessor;
import dev.isxander.controlify.screenop.keyboard.InputTarget;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayout;
import dev.isxander.controlify.screenop.keyboard.KeyboardLayoutWithId;
import dev.isxander.controlify.screenop.keyboard.KeyboardWidget;
import dev.isxander.controlify.utils.CUtil;
import dev.isxander.controlify.utils.HoldRepeatHelper;
import dev.isxander.controlify.utils.render.Blit;
import dev.isxander.controlify.utils.render.CGuiPose;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_6382;

public class KeyWidget
extends class_339
implements ComponentProcessor,
ScreenControllerEventListener {
    public static final class_2960 SPRITE = CUtil.rl("keyboard/key");
    public static final class_2960 SPRITE_PRESSED = CUtil.rl("keyboard/key_pressed");
    private final KeyboardWidget keyboard;
    private final KeyboardLayout.Key key;
    private final class_2561 regularLabel;
    private final class_2561 shiftedLabel;
    private final boolean supportsRegular;
    private final boolean supportsShifted;
    private boolean shortcutPressed;
    private final HoldRepeatHelper holdRepeatHelper;
    private boolean buttonPressed;
    private boolean mousePressed;
    private final int renderScale;
    private final int renderWidth;
    private final int renderHeight;

    public KeyWidget(int x, int y, int width, int height, int renderScale, KeyboardLayout.Key key, KeyboardWidget keyboard) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"Key"));
        this.keyboard = keyboard;
        this.key = key;
        this.holdRepeatHelper = new HoldRepeatHelper(10, 2);
        this.regularLabel = KeyWidget.createLabel(key, false);
        this.shiftedLabel = KeyWidget.createLabel(key, true);
        this.supportsRegular = this.supportsAction(false);
        this.supportsShifted = this.supportsAction(true);
        this.renderScale = renderScale;
        this.renderWidth = width / renderScale;
        this.renderHeight = height / renderScale;
    }

    public void renderKeyBackground(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.field_22763 = this.supportsAction();
        if (!this.method_25370()) {
            this.buttonPressed = false;
        }
        this.doScaledRender(graphics, () -> {
            Blit.sprite(graphics, this.isVisuallyPressed() ? SPRITE_PRESSED : SPRITE, this.method_46426() + 1, this.method_46427() + 1, this.renderWidth - 2, this.renderHeight - 2);
            if (this.method_25367()) {
                graphics.method_73198(this.method_46426() - 1, this.method_46427() - 1, this.renderWidth + 2, this.renderHeight + 2, -2130706433);
            } else if (!this.shortcutPressed) {
                this.holdRepeatHelper.reset();
            }
            if (!this.field_22763) {
                graphics.method_25294(this.method_46426() + 1, this.method_46427() + 1, this.method_46426() + this.renderWidth - 1, this.method_46427() + this.renderHeight - 1, 0x30000000);
            }
        });
    }

    public void renderKeyForeground(class_332 graphics, int mouseX, int mouseY, float deltaTick) {
        this.doScaledRender(graphics, () -> {
            class_2561 label = this.keyboard.isShifted() ? this.shiftedLabel : this.regularLabel;
            graphics.method_27534(class_310.method_1551().field_1772, label, this.method_46426() + this.renderWidth / 2, this.method_46427() + this.renderHeight / 2 - 4 + (this.isVisuallyPressed() ? 2 : 0), -1);
        });
    }

    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public boolean overrideControllerButtons(ScreenProcessor<?> screen, ControllerEntity controller) {
        InputBinding guiPress = ControlifyBindings.GUI_PRESS.on(controller);
        if (guiPress.justPressed()) {
            this.buttonPressed = true;
        } else if (guiPress.justReleased()) {
            this.buttonPressed = false;
        }
        if (this.buttonPressed && this.holdRepeatHelper.shouldAction(guiPress)) {
            this.onPress();
            this.holdRepeatHelper.onNavigate();
        }
        return false;
    }

    @Override
    public void onControllerInput(ControllerEntity controller) {
        this.key.shortcutBinding().ifPresent(supplier -> {
            InputBinding shortcutBinding = supplier.on(controller);
            this.shortcutPressed = shortcutBinding.digitalNow();
            if (this.holdRepeatHelper.shouldAction(shortcutBinding)) {
                this.onPress();
                this.holdRepeatHelper.onNavigate();
            }
        });
    }

    public boolean method_25402(class_11909 mouseButtonEvent, boolean bl) {
        double mouseY;
        double mouseX = mouseButtonEvent.comp_4798();
        if (this.method_25405(mouseX, mouseY = mouseButtonEvent.comp_4799())) {
            this.mousePressed = true;
            this.onPress();
            return true;
        }
        return false;
    }

    public boolean method_25406(class_11909 mouseButtonEvent) {
        this.mousePressed = false;
        return super.method_25406(mouseButtonEvent);
    }

    private void onPress() {
        KeyboardLayout.KeyFunction keyFunction = this.getKeyFunction();
        InputTarget inputConsumer = this.keyboard.getInputTarget();
        ScreenProcessor.playClackSound();
        boolean wasShiftAction = false;
        KeyboardLayout.KeyFunction keyFunction2 = keyFunction;
        Objects.requireNonNull(keyFunction2);
        KeyboardLayout.KeyFunction keyFunction3 = keyFunction2;
        int n = 0;
        block0 : switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KeyboardLayout.KeyFunction.StringFunc.class, KeyboardLayout.KeyFunction.CodeFunc.class, KeyboardLayout.KeyFunction.SpecialFunc.class, KeyboardLayout.KeyFunction.ChangeLayoutFunc.class}, (Object)keyFunction3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                KeyboardLayout.KeyFunction.StringFunc stringKey = (KeyboardLayout.KeyFunction.StringFunc)keyFunction3;
                KeyWidget.insertText(stringKey.string(), inputConsumer);
                break;
            }
            case 1: {
                KeyboardLayout.KeyFunction.CodeFunc codeKey = (KeyboardLayout.KeyFunction.CodeFunc)keyFunction3;
                codeKey.codes().forEach(code -> inputConsumer.acceptKeyCode(code.keycode(), code.scancode(), code.modifier()));
                break;
            }
            case 2: {
                KeyboardLayout.KeyFunction.SpecialFunc specialKey = (KeyboardLayout.KeyFunction.SpecialFunc)keyFunction3;
                switch (specialKey.action()) {
                    case SHIFT: {
                        this.toggleShift();
                        wasShiftAction = true;
                        break block0;
                    }
                    case SHIFT_LOCK: {
                        this.toggleShiftLock();
                        wasShiftAction = true;
                        break block0;
                    }
                    case ENTER: {
                        inputConsumer.acceptKeyCode(257, 0, 0);
                        break block0;
                    }
                    case BACKSPACE: {
                        inputConsumer.acceptKeyCode(259, 0, 0);
                        break block0;
                    }
                    case TAB: {
                        inputConsumer.acceptKeyCode(258, 0, 0);
                        break block0;
                    }
                    case LEFT_ARROW: {
                        inputConsumer.acceptKeyCode(263, 0, 0);
                        break block0;
                    }
                    case RIGHT_ARROW: {
                        inputConsumer.acceptKeyCode(262, 0, 0);
                        break block0;
                    }
                    case UP_ARROW: {
                        inputConsumer.acceptKeyCode(265, 0, 0);
                        break block0;
                    }
                    case DOWN_ARROW: {
                        inputConsumer.acceptKeyCode(264, 0, 0);
                        break block0;
                    }
                    case PASTE: {
                        String clipboard = class_310.method_1551().field_1774.method_1460();
                        KeyWidget.insertText(clipboard, inputConsumer);
                        break block0;
                    }
                    case COPY_ALL: {
                        inputConsumer.copy();
                        break block0;
                    }
                    case PREVIOUS_LAYOUT: {
                        this.keyboard.getPreviousLayoutId().ifPresent(this::changeLayout);
                        break block0;
                    }
                }
                CUtil.LOGGER.warn("Unhandled code action: " + String.valueOf((Object)specialKey.action()));
                break;
            }
            case 3: {
                KeyboardLayout.KeyFunction.ChangeLayoutFunc func = (KeyboardLayout.KeyFunction.ChangeLayoutFunc)keyFunction3;
                this.changeLayout(func.layout());
            }
        }
        if (!wasShiftAction && this.keyboard.isShifted() && !this.keyboard.isShiftLocked() && this.key.regular() != this.key.shifted()) {
            this.keyboard.setShifted(false);
        }
    }

    protected void toggleShift() {
        if (!this.keyboard.isShiftLocked()) {
            this.keyboard.setShifted(!this.keyboard.isShifted());
        } else {
            this.keyboard.setShifted(false);
            this.keyboard.setShiftLocked(false);
        }
    }

    protected void toggleShiftLock() {
        boolean shiftLocked = !this.keyboard.isShiftLocked();
        this.keyboard.setShiftLocked(shiftLocked);
        this.keyboard.setShifted(shiftLocked);
    }

    public KeyboardLayout.Key getKey() {
        return this.key;
    }

    public KeyboardLayout.KeyFunction getKeyFunction() {
        return this.key.getFunction(this.keyboard.isShifted());
    }

    public boolean isVisuallyPressed() {
        return this.buttonPressed || this.shortcutPressed || this.mousePressed || this.isShiftKeyAndShifting() || this.isShiftLockKeyAndShiftLocked();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isShiftKeyAndShifting() {
        if (!this.keyboard.isShifted()) return false;
        if (this.keyboard.isShiftLocked()) return false;
        KeyboardLayout.KeyFunction keyFunction = this.getKeyFunction();
        if (!(keyFunction instanceof KeyboardLayout.KeyFunction.SpecialFunc)) return false;
        KeyboardLayout.KeyFunction.SpecialFunc specialFunc = (KeyboardLayout.KeyFunction.SpecialFunc)keyFunction;
        try {
            KeyboardLayout.KeyFunction.SpecialFunc.Action action;
            KeyboardLayout.KeyFunction.SpecialFunc.Action action2 = action = specialFunc.action();
            if (action2 != KeyboardLayout.KeyFunction.SpecialFunc.Action.SHIFT) return false;
            return true;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isShiftLockKeyAndShiftLocked() {
        if (!this.keyboard.isShiftLocked()) return false;
        KeyboardLayout.KeyFunction keyFunction = this.getKeyFunction();
        if (!(keyFunction instanceof KeyboardLayout.KeyFunction.SpecialFunc)) return false;
        KeyboardLayout.KeyFunction.SpecialFunc specialFunc = (KeyboardLayout.KeyFunction.SpecialFunc)keyFunction;
        try {
            KeyboardLayout.KeyFunction.SpecialFunc.Action action;
            KeyboardLayout.KeyFunction.SpecialFunc.Action action2 = action = specialFunc.action();
            if (action2 != KeyboardLayout.KeyFunction.SpecialFunc.Action.SHIFT_LOCK) return false;
            return true;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private boolean supportsAction(boolean shifted) {
        boolean supportsCharInput = this.keyboard.getInputTarget().supportsCharInput();
        boolean supportsKeyCodeInput = this.keyboard.getInputTarget().supportsKeyCodeInput();
        boolean supportsCopying = this.keyboard.getInputTarget().supportsCopying();
        KeyboardLayout.KeyFunction keyFunction = this.getKey().getFunction(shifted);
        Objects.requireNonNull(keyFunction);
        KeyboardLayout.KeyFunction keyFunction2 = keyFunction;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{KeyboardLayout.KeyFunction.StringFunc.class, KeyboardLayout.KeyFunction.CodeFunc.class, KeyboardLayout.KeyFunction.SpecialFunc.class, KeyboardLayout.KeyFunction.ChangeLayoutFunc.class}, (Object)keyFunction2, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                KeyboardLayout.KeyFunction.StringFunc ignored = (KeyboardLayout.KeyFunction.StringFunc)keyFunction2;
                yield supportsCharInput;
            }
            case 1 -> {
                KeyboardLayout.KeyFunction.CodeFunc ignored = (KeyboardLayout.KeyFunction.CodeFunc)keyFunction2;
                yield supportsKeyCodeInput;
            }
            case 2 -> {
                KeyboardLayout.KeyFunction.SpecialFunc specialFunc = (KeyboardLayout.KeyFunction.SpecialFunc)keyFunction2;
                switch (specialFunc.action()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case ENTER: 
                    case BACKSPACE: 
                    case LEFT_ARROW: 
                    case RIGHT_ARROW: 
                    case UP_ARROW: 
                    case DOWN_ARROW: {
                        yield supportsKeyCodeInput;
                    }
                    case TAB: 
                    case PASTE: {
                        yield supportsCharInput;
                    }
                    case COPY_ALL: {
                        yield supportsCopying;
                    }
                    case SHIFT: 
                    case SHIFT_LOCK: 
                    case PREVIOUS_LAYOUT: 
                }
                yield true;
            }
            case 3 -> {
                KeyboardLayout.KeyFunction.ChangeLayoutFunc ignored = (KeyboardLayout.KeyFunction.ChangeLayoutFunc)keyFunction2;
                yield true;
            }
        };
    }

    private boolean supportsAction() {
        return this.keyboard.isShifted() ? this.supportsShifted : this.supportsRegular;
    }

    private void changeLayout(class_2960 layoutId) {
        KeyboardLayoutWithId layoutWithId = Controlify.instance().keyboardLayoutManager().getLayout(layoutId);
        this.keyboard.updateLayout(layoutWithId);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    private void doScaledRender(class_332 graphics, Runnable runnable) {
        CGuiPose pose = CGuiPose.ofPush(graphics);
        pose.translate(this.method_46426(), this.method_46427());
        pose.scale(this.renderScale, this.renderScale);
        pose.translate(-this.method_46426(), -this.method_46427());
        runnable.run();
        pose.pop();
    }

    private static void insertText(String text, InputTarget inputConsumer) {
        text.codePoints().forEach(codePoint -> {
            int modCapital;
            int modifiers = modCapital = Character.isUpperCase(codePoint) ? 1 : 0;
            if (Character.isBmpCodePoint(codePoint)) {
                inputConsumer.acceptChar((char)codePoint, modifiers);
            } else if (Character.isValidCodePoint(codePoint)) {
                inputConsumer.acceptChar(Character.highSurrogate(codePoint), modifiers);
                inputConsumer.acceptChar(Character.lowSurrogate(codePoint), modifiers);
            }
        });
    }

    private static class_2561 createLabel(KeyboardLayout.Key key, boolean shift) {
        KeyboardLayout.KeyFunction keyFunction = key.getFunction(shift);
        return key.shortcutBinding().map(b -> BindingFontHelper.binding(b.bindId())).map(glyph -> class_2561.method_43473().method_10852(glyph).method_27693(" ").method_10852(keyFunction.displayName())).orElseGet(keyFunction::displayName);
    }
}

