/*
 * Decompiled with CFR 0.152.
 */
package dev.isxander.yacl3.gui.controllers.dropdown;

import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import dev.isxander.yacl3.api.utils.Dimension;
import dev.isxander.yacl3.gui.AbstractWidget;
import dev.isxander.yacl3.gui.YACLScreen;
import dev.isxander.yacl3.gui.controllers.dropdown.AbstractDropdownController;
import dev.isxander.yacl3.gui.controllers.dropdown.EnumDropdownControllerElement;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;

public class EnumDropdownController<E extends Enum<E>>
extends AbstractDropdownController<E> {
    protected final ValueFormatter<E> formatter;

    public EnumDropdownController(Option<E> option, ValueFormatter<E> formatter) {
        super(option, Arrays.stream((Enum[])((Enum)option.pendingValue()).getDeclaringClass().getEnumConstants()).map(formatter::format).map(class_2561::getString).toList());
        this.formatter = formatter;
    }

    @Override
    public String getString() {
        return this.formatter.format((Enum)this.option().pendingValue()).getString();
    }

    @Override
    public void setFromString(String value) {
        this.option().requestSet(this.getEnumFromString(value));
    }

    private E getEnumFromString(String value) {
        value = value.toLowerCase();
        for (Enum constant : (Enum[])((Enum)this.option().pendingValue()).getDeclaringClass().getEnumConstants()) {
            if (!this.formatter.format(constant).getString().toLowerCase().equals(value)) continue;
            return (E)constant;
        }
        return (E)((Enum)this.option().pendingValue());
    }

    @Override
    public boolean isValueValid(String value) {
        value = value.toLowerCase();
        for (String constant : this.getAllowedValues()) {
            if (!constant.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected String getValidValue(String value, int offset) {
        return this.getValidEnumConstants(value).skip(offset).findFirst().orElseGet(this::getString);
    }

    @NotNull
    protected Stream<String> getValidEnumConstants(String value) {
        String valueLowerCase = value.toLowerCase();
        return this.getAllowedValues().stream().filter(constant -> constant.toLowerCase().contains(valueLowerCase)).sorted((s1, s2) -> {
            String s1LowerCase = s1.toLowerCase();
            String s2LowerCase = s2.toLowerCase();
            if (s1LowerCase.startsWith(valueLowerCase) && !s2LowerCase.startsWith(valueLowerCase)) {
                return -1;
            }
            if (!s1LowerCase.startsWith(valueLowerCase) && s2LowerCase.startsWith(valueLowerCase)) {
                return 1;
            }
            return s1.compareTo((String)s2);
        });
    }

    @Override
    public AbstractWidget provideWidget(YACLScreen screen, Dimension<Integer> widgetDimension) {
        return new EnumDropdownControllerElement(this, screen, widgetDimension);
    }
}

