/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.autoreconnectrf;

import dev.terminalmc.autoreconnectrf.config.Config;
import dev.terminalmc.autoreconnectrf.reconnect.ReconnectStrategy;
import dev.terminalmc.autoreconnectrf.reconnect.WorldReconnectStrategy;
import dev.terminalmc.autoreconnectrf.util.MessageUtil;
import dev.terminalmc.autoreconnectrf.util.ModLogger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntConsumer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_419;
import net.minecraft.class_4325;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_500;
import net.minecraft.class_526;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AutoReconnect {
    public static final String MOD_ID = "autoreconnectrf";
    public static final String MOD_NAME = "AutoReconnect";
    public static final ModLogger LOG = new ModLogger("AutoReconnect");
    public static final class_2561 PREFIX = class_2561.method_43473().method_10852((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1063)).method_10852((class_2561)class_2561.method_43470((String)"AutoReconnect").method_27692(class_124.field_1065)).method_10852((class_2561)class_2561.method_43470((String)"] ").method_27692(class_124.field_1063)).method_27692(class_124.field_1080);
    public static final List<Pattern> conditionPatterns = new ArrayList<Pattern>();
    @Nullable
    public static String lastDcReasonStr = null;
    @Nullable
    public static String lastDcReasonKey = null;
    private static final ScheduledThreadPoolExecutor EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(1);
    private static final AtomicReference<ScheduledFuture<?>> countdown;
    @Nullable
    private static ReconnectStrategy reconnectStrategy;

    public static void init() {
        Config.getAndSave();
    }

    public static void afterClientTick(class_310 mc) {
    }

    public static void onConfigSaved(Config config) {
        conditionPatterns.clear();
        for (String s : config.options.conditionPatterns) {
            try {
                conditionPatterns.add(Pattern.compile(s));
            }
            catch (PatternSyntaxException patternSyntaxException) {}
        }
    }

    public static void onScreenChanged(@Nullable class_437 current, @Nullable class_437 next) {
        if (AutoReconnect.isSameType(current, next)) {
            return;
        }
        if (!AutoReconnect.isMainScreen(current) && AutoReconnect.isMainScreen(next) || AutoReconnect.isReAuthenticating(current, next)) {
            AutoReconnect.cancelAutoReconnect();
        }
    }

    public static void onGameJoined() {
        if (reconnectStrategy == null) {
            return;
        }
        if (!reconnectStrategy.isAttempting()) {
            return;
        }
        reconnectStrategy.resetAttempts();
        Config.get().getAutoMessagesForId(reconnectStrategy.getId()).forEach(autoMessage -> MessageUtil.sendAll(autoMessage.getMessages(), (int)(autoMessage.delay * 1000.0f)));
    }

    public static void setReconnectStrategy(@NotNull ReconnectStrategy pReconnectStrategy) {
        if (reconnectStrategy == null) {
            reconnectStrategy = pReconnectStrategy;
        }
    }

    public static boolean canReconnect() {
        return reconnectStrategy != null;
    }

    public static void reconnect() {
        AutoReconnect.cancelCountdown();
        if (reconnectStrategy != null) {
            reconnectStrategy.reconnect();
        }
    }

    public static void manualReconnect() {
        AutoReconnect.cancelActiveReconnect();
        AutoReconnect.reconnect();
    }

    public static void cancelAutoReconnect() {
        AutoReconnect.cancelActiveReconnect();
        reconnectStrategy = null;
    }

    public static void cancelActiveReconnect() {
        if (reconnectStrategy != null) {
            reconnectStrategy.resetAttempts();
        }
        AutoReconnect.cancelCountdown();
    }

    public static ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit timeUnit) {
        return EXECUTOR_SERVICE.schedule(command, delay, timeUnit);
    }

    public static void startCountdown(IntConsumer callback) {
        int delay = Config.get().getDelayForAttempt(reconnectStrategy.nextAttempt());
        if (delay >= 0) {
            AutoReconnect.countdown(delay, callback);
        } else {
            callback.accept(-1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cancelCountdown() {
        AtomicReference<ScheduledFuture<?>> atomicReference = countdown;
        synchronized (atomicReference) {
            if (countdown.get() == null) {
                return;
            }
            ((ScheduledFuture)countdown.getAndSet(null)).cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void countdown(int seconds, IntConsumer callback) {
        if (reconnectStrategy == null) {
            return;
        }
        if (seconds == 0) {
            class_310.method_1551().execute(AutoReconnect::reconnect);
        } else {
            callback.accept(seconds);
            AtomicReference<ScheduledFuture<?>> atomicReference = countdown;
            synchronized (atomicReference) {
                countdown.set(AutoReconnect.schedule(() -> AutoReconnect.countdown(seconds - 1, callback), 1L, TimeUnit.SECONDS));
            }
        }
    }

    public static boolean isPlayingSingleplayer() {
        return reconnectStrategy instanceof WorldReconnectStrategy;
    }

    private static boolean isSameType(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a != null && b != null) {
            return a.getClass().equals(b.getClass());
        }
        return false;
    }

    private static boolean isMainScreen(class_437 screen) {
        return screen instanceof class_442 || screen instanceof class_526 || screen instanceof class_500 || screen instanceof class_4325;
    }

    private static boolean isReAuthenticating(class_437 current, class_437 next) {
        return current instanceof class_419 && next != null && next.getClass().getName().startsWith("me.axieum.mcmod.authme");
    }

    static {
        EXECUTOR_SERVICE.setRemoveOnCancelPolicy(true);
        countdown = new AtomicReference<Object>(null);
        reconnectStrategy = null;
    }
}

