/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api;

import com.google.common.collect.ImmutableMap;
import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.PlaceholderHandler;
import eu.pb4.placeholders.api.PlaceholderResult;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.parent.ParentNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.api.parsers.PatternPlaceholderParser;
import eu.pb4.placeholders.api.parsers.TagLikeParser;
import eu.pb4.placeholders.impl.placeholder.builtin.PlayerPlaceholders;
import eu.pb4.placeholders.impl.placeholder.builtin.ServerPlaceholders;
import eu.pb4.placeholders.impl.placeholder.builtin.WorldPlaceholders;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class Placeholders {
    @Deprecated(forRemoval=true)
    public static final Pattern PLACEHOLDER_PATTERN = PatternPlaceholderParser.PLACEHOLDER_PATTERN;
    @Deprecated(forRemoval=true)
    public static final Pattern ALT_PLACEHOLDER_PATTERN = PatternPlaceholderParser.ALT_PLACEHOLDER_PATTERN;
    @Deprecated(forRemoval=true)
    public static final Pattern PLACEHOLDER_PATTERN_CUSTOM = PatternPlaceholderParser.PLACEHOLDER_PATTERN_CUSTOM;
    @Deprecated(forRemoval=true)
    public static final Pattern ALT_PLACEHOLDER_PATTERN_CUSTOM = PatternPlaceholderParser.ALT_PLACEHOLDER_PATTERN_CUSTOM;
    @Deprecated(forRemoval=true)
    public static final Pattern PREDEFINED_PLACEHOLDER_PATTERN = PatternPlaceholderParser.PREDEFINED_PLACEHOLDER_PATTERN;
    private static final HashMap<class_2960, PlaceholderHandler> PLACEHOLDERS = new HashMap();
    private static final List<PlaceholderListChangedCallback> CHANGED_CALLBACKS = new ArrayList<PlaceholderListChangedCallback>();
    public static final PlaceholderGetter DEFAULT_PLACEHOLDER_GETTER = new PlaceholderGetter(){

        @Override
        public PlaceholderHandler getPlaceholder(String placeholder) {
            return PLACEHOLDERS.get(class_2960.method_12829((String)placeholder));
        }

        @Override
        public boolean isContextOptional() {
            return false;
        }
    };
    public static final NodeParser DEFAULT_PLACEHOLDER_PARSER = TagLikeParser.placeholder(TagLikeParser.PLACEHOLDER, PlaceholderContext.KEY, DEFAULT_PLACEHOLDER_GETTER);

    public static PlaceholderResult parsePlaceholder(class_2960 identifier, String argument, PlaceholderContext context) {
        if (PLACEHOLDERS.containsKey(identifier)) {
            return PLACEHOLDERS.get(identifier).onPlaceholderRequest(context, argument);
        }
        return PlaceholderResult.invalid("Placeholder doesn't exist!");
    }

    public static ParentNode parseNodes(TextNode node) {
        return Placeholders.asSingleParent(DEFAULT_PLACEHOLDER_PARSER.parseNodes(node));
    }

    public static ParentNode parseNodes(TextNode node, ParserContext.Key<PlaceholderContext> contextKey) {
        return Placeholders.asSingleParent(TagLikeParser.placeholder(TagLikeParser.PLACEHOLDER, contextKey, DEFAULT_PLACEHOLDER_GETTER).parseNodes(node));
    }

    public static class_2561 parseText(class_2561 text, PlaceholderContext context) {
        return Placeholders.parseNodes(TextNode.convert(text)).toText(ParserContext.of(PlaceholderContext.KEY, context));
    }

    public static class_2561 parseText(TextNode textNode, PlaceholderContext context) {
        return Placeholders.parseNodes(textNode).toText(ParserContext.of(PlaceholderContext.KEY, context));
    }

    @Deprecated(forRemoval=true)
    public static ParentNode parseNodes(TextNode node, Pattern pattern) {
        return Placeholders.parseNodes(node, pattern, PlaceholderContext.KEY);
    }

    @Deprecated(forRemoval=true)
    public static ParentNode parseNodes(TextNode node, Pattern pattern, ParserContext.Key<PlaceholderContext> contextKey) {
        return Placeholders.asSingleParent(PatternPlaceholderParser.of(pattern, contextKey, DEFAULT_PLACEHOLDER_GETTER).parseNodes(node));
    }

    @Deprecated(forRemoval=true)
    public static ParentNode parseNodes(TextNode node, Pattern pattern, PlaceholderGetter placeholderGetter) {
        return Placeholders.parseNodes(node, pattern, placeholderGetter, PlaceholderContext.KEY);
    }

    @Deprecated(forRemoval=true)
    public static ParentNode parseNodes(TextNode node, Pattern pattern, PlaceholderGetter placeholderGetter, ParserContext.Key<PlaceholderContext> contextKey) {
        return Placeholders.asSingleParent(PatternPlaceholderParser.of(pattern, contextKey, placeholderGetter).parseNodes(node));
    }

    @Deprecated(forRemoval=true)
    public static ParentNode parseNodes(TextNode node, Pattern pattern, Map<String, class_2561> placeholders) {
        return Placeholders.asSingleParent(PatternPlaceholderParser.ofTextMap(pattern, placeholders).parseNodes(node));
    }

    @Deprecated(forRemoval=true)
    public static ParentNode parseNodes(TextNode node, Pattern pattern, Set<String> placeholders, ParserContext.Key<PlaceholderGetter> key) {
        return Placeholders.parseNodes(node, pattern, placeholders, key, PlaceholderContext.KEY);
    }

    @Deprecated(forRemoval=true)
    public static ParentNode parseNodes(TextNode node, Pattern pattern, final Set<String> placeholders, final ParserContext.Key<PlaceholderGetter> key, ParserContext.Key<PlaceholderContext> contextKey) {
        return Placeholders.asSingleParent(PatternPlaceholderParser.of(pattern, contextKey, new PlaceholderGetter(){

            @Override
            public PlaceholderHandler getPlaceholder(String placeholder, ParserContext context) {
                PlaceholderGetter get = (PlaceholderGetter)context.get(key);
                return get != null ? get.getPlaceholder(placeholder, context) : null;
            }

            @Override
            public PlaceholderHandler getPlaceholder(String placeholder) {
                return placeholders.contains(placeholder) ? PlaceholderHandler.EMPTY : null;
            }

            @Override
            public boolean isContextOptional() {
                return true;
            }
        }).parseNodes(node));
    }

    @Deprecated(forRemoval=true)
    public static class_2561 parseText(class_2561 text, PlaceholderContext context, Pattern pattern) {
        return Placeholders.parseNodes(TextNode.convert(text), pattern).toText(ParserContext.of(PlaceholderContext.KEY, context));
    }

    @Deprecated(forRemoval=true)
    public static class_2561 parseText(class_2561 text, PlaceholderContext context, Pattern pattern, PlaceholderGetter placeholderGetter) {
        return Placeholders.parseNodes(TextNode.convert(text), pattern, placeholderGetter).toText(ParserContext.of(PlaceholderContext.KEY, context));
    }

    @Deprecated(forRemoval=true)
    public static class_2561 parseText(class_2561 text, Pattern pattern, Map<String, class_2561> placeholders) {
        return Placeholders.parseNodes(TextNode.convert(text), pattern, placeholders).toText(ParserContext.of());
    }

    @Deprecated(forRemoval=true)
    public static class_2561 parseText(class_2561 text, Pattern pattern, Set<String> placeholders, ParserContext.Key<PlaceholderGetter> key) {
        return Placeholders.parseNodes(TextNode.convert(text), pattern, placeholders, key).toText(ParserContext.of());
    }

    @Deprecated(forRemoval=true)
    public static class_2561 parseText(TextNode textNode, PlaceholderContext context, Pattern pattern) {
        return Placeholders.parseNodes(textNode, pattern).toText(ParserContext.of(PlaceholderContext.KEY, context));
    }

    @Deprecated(forRemoval=true)
    public static class_2561 parseText(TextNode textNode, PlaceholderContext context, Pattern pattern, PlaceholderGetter placeholderGetter) {
        return Placeholders.parseNodes(textNode, pattern, placeholderGetter).toText(ParserContext.of(PlaceholderContext.KEY, context));
    }

    @Deprecated(forRemoval=true)
    public static class_2561 parseText(TextNode textNode, PlaceholderContext context, Pattern pattern, Map<String, class_2561> placeholders) {
        return Placeholders.parseNodes(textNode, pattern, placeholders).toText(ParserContext.of(PlaceholderContext.KEY, context));
    }

    @Deprecated(forRemoval=true)
    public static class_2561 parseText(TextNode textNode, Pattern pattern, Map<String, class_2561> placeholders) {
        return Placeholders.parseNodes(textNode, pattern, placeholders).toText();
    }

    @Deprecated(forRemoval=true)
    public static class_2561 parseText(TextNode textNode, Pattern pattern, Set<String> placeholders, ParserContext.Key<PlaceholderGetter> key) {
        return Placeholders.parseNodes(textNode, pattern, placeholders, key).toText();
    }

    public static void register(class_2960 identifier, PlaceholderHandler handler) {
        PLACEHOLDERS.put(identifier, handler);
        for (PlaceholderListChangedCallback e : CHANGED_CALLBACKS) {
            e.onPlaceholderListChange(identifier, false);
        }
    }

    public static void remove(class_2960 identifier) {
        if (PLACEHOLDERS.remove(identifier) != null) {
            for (PlaceholderListChangedCallback e : CHANGED_CALLBACKS) {
                e.onPlaceholderListChange(identifier, true);
            }
        }
    }

    public static ImmutableMap<class_2960, PlaceholderHandler> getPlaceholders() {
        return ImmutableMap.copyOf(PLACEHOLDERS);
    }

    public static void registerChangeEvent(PlaceholderListChangedCallback callback) {
        CHANGED_CALLBACKS.add(callback);
    }

    private static ParentNode asSingleParent(TextNode ... textNodes) {
        if (textNodes.length == 1 && textNodes[0] instanceof ParentNode) {
            return (ParentNode)textNodes[0];
        }
        return new ParentNode(textNodes);
    }

    static {
        PlayerPlaceholders.register();
        ServerPlaceholders.register();
        WorldPlaceholders.register();
    }

    public static interface PlaceholderGetter {
        @Nullable
        public PlaceholderHandler getPlaceholder(String var1);

        @Nullable
        default public PlaceholderHandler getPlaceholder(String placeholder, ParserContext context) {
            return this.getPlaceholder(placeholder);
        }

        default public boolean isContextOptional() {
            return false;
        }

        default public boolean exists(String placeholder) {
            return this.getPlaceholder(placeholder) != null;
        }
    }

    public static interface PlaceholderListChangedCallback {
        public void onPlaceholderListChange(class_2960 var1, boolean var2);
    }
}

