/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viafabricplus.features.entity;

import com.viaversion.viafabricplus.base.Events;
import com.viaversion.viafabricplus.protocoltranslator.impl.ViaFabricPlusMappingDataLoader;
import com.viaversion.viaversion.api.protocol.version.ProtocolVersion;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4048;
import net.minecraft.class_7923;

public final class EntityDimensionDiff {
    private static final Map<class_1299<?>, Map<ProtocolVersion, class_4048>> ENTITY_DIMENSIONS = new HashMap();

    public static void init() {
        JsonObject dimensionDiff = ViaFabricPlusMappingDataLoader.INSTANCE.loadData("entity-dimensions.json");
        for (String entity : dimensionDiff.keySet()) {
            class_1299 entityType = class_7923.field_41177.method_17966(class_2960.method_60654((String)entity)).orElse(null);
            if (entityType == null) {
                throw new IllegalStateException("Unknown entity: " + entity);
            }
            JsonObject versions = dimensionDiff.getAsJsonObject(entity);
            HashMap<ProtocolVersion, class_4048> dimensionMap = new HashMap<ProtocolVersion, class_4048>();
            for (String version : versions.keySet()) {
                ProtocolVersion protocolVersion = ProtocolVersion.getClosest((String)version);
                if (protocolVersion == null) {
                    throw new IllegalStateException("Unknown protocol version: " + version);
                }
                JsonObject dimensionData = versions.getAsJsonObject(version);
                float width = dimensionData.get("width").getAsFloat();
                float height = dimensionData.get("height").getAsFloat();
                float eyeHeight = dimensionData.get("eyeHeight").getAsFloat();
                boolean fixed = dimensionData.get("fixed").getAsBoolean();
                class_4048 entityDimensions = new class_4048(width, height, eyeHeight, entityType.field_18070.comp_2188(), fixed);
                dimensionMap.put(protocolVersion, entityDimensions);
            }
            ENTITY_DIMENSIONS.put(entityType, dimensionMap);
        }
        Events.CHANGE_PROTOCOL_VERSION.register((oldVersion, newVersion) -> class_310.method_1551().execute(() -> ENTITY_DIMENSIONS.forEach((entityType, dimensionMap) -> {
            for (Map.Entry entry : dimensionMap.entrySet()) {
                ProtocolVersion version = (ProtocolVersion)entry.getKey();
                class_4048 dimensions = (class_4048)entry.getValue();
                if (oldVersion.newerThan(version) && newVersion.olderThanOrEqualTo(version)) {
                    entityType.field_18070 = dimensions;
                    break;
                }
                if (!newVersion.newerThanOrEqualTo(version) || !oldVersion.olderThanOrEqualTo(version)) continue;
                entityType.field_18070 = dimensions;
            }
        })));
    }
}

