/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.smoke_suppression;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.minecraft.class_1269;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.sssubtlety.smoke_suppression.Config;
import net.sssubtlety.smoke_suppression.SmokeSuppression;
import net.sssubtlety.smoke_suppression.Util;
import org.jetbrains.annotations.Nullable;

public final class FeatureControl {
    @Nullable
    private static final Config CONFIG_INSTANCE;
    private static ImmutableSet<class_2248> suppressingBlocks;

    private FeatureControl() {
    }

    private static class_1269 onConfigChange(ConfigHolder<Config> configHolder, Config config) {
        assert (config == CONFIG_INSTANCE);
        suppressingBlocks = FeatureControl.buildBlockSetFromStrings(config.suppressing_blocks);
        return class_1269.field_21466;
    }

    public static boolean shouldSmoke(Supplier<@Nullable class_2248> blockSupplier) {
        if (CONFIG_INSTANCE == null) {
            return !Defaults.suppressingBlocks.contains((Object)blockSupplier.get());
        }
        if (FeatureControl.CONFIG_INSTANCE.always_suppress_smoke) {
            return false;
        }
        return FeatureControl.CONFIG_INSTANCE.invert_list_behavior == suppressingBlocks.contains((Object)blockSupplier.get());
    }

    private static ImmutableSet<class_2248> buildBlockSetFromStrings(List<String> blockStrings) {
        ImmutableSet.Builder blockSetBuilder = ImmutableSet.builder();
        for (String string : blockStrings) {
            class_2960 id = class_2960.method_60654((String)string);
            class_7923.field_41175.method_17966(id).ifPresentOrElse(arg_0 -> ((ImmutableSet.Builder)blockSetBuilder).add(arg_0), () -> SmokeSuppression.LOGGER.warn("No block found for id: {}", (Object)id));
        }
        return blockSetBuilder.build();
    }

    public static boolean isConfigLoaded() {
        return CONFIG_INSTANCE != null;
    }

    public static void init() {
    }

    static {
        suppressingBlocks = Defaults.suppressingBlocks;
        if (Util.isModLoaded("cloth-config", ">=6.1.48")) {
            ConfigHolder holder = AutoConfig.register(Config.class, GsonConfigSerializer::new);
            CONFIG_INSTANCE = (Config)holder.getConfig();
            FeatureControl.onConfigChange((ConfigHolder<Config>)holder, CONFIG_INSTANCE);
            holder.registerSaveListener(FeatureControl::onConfigChange);
            holder.registerLoadListener(FeatureControl::onConfigChange);
        } else {
            CONFIG_INSTANCE = null;
        }
    }

    public static interface Defaults {
        public static final ImmutableList<String> suppressingBlockIds = ImmutableList.of((Object)class_7923.field_41175.method_10221((Object)class_2246.field_10312).toString(), (Object)class_7923.field_41175.method_10221((Object)class_2246.field_10167).toString(), (Object)class_7923.field_41175.method_10221((Object)class_2246.field_10546).toString(), (Object)class_7923.field_41175.method_10221((Object)class_2246.field_10425).toString(), (Object)class_7923.field_41175.method_10221((Object)class_2246.field_10025).toString());
        public static final ImmutableSet<class_2248> suppressingBlocks = FeatureControl.buildBlockSetFromStrings(suppressingBlockIds);
        public static final boolean invert_list_behavior = false;
        public static final boolean always_suppress_smoke = false;
    }
}

